#==============================================================================
#  Window_Actor_Menu_Item_Trade
#------------------------------------------------------------------------------
# 킽ACeAN^[j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Actor_Menu_Item_Trade < Window_Actor_Menu_Base
    include Menu_Log_Item_Module
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent,title)
      super(parent,title)

      # ӂ냁j[ǉ
      add_menu('ӂ', :select_party_backpack)
      pack

      # ʒu̐ݒ
      self.top  = top_window.top
      self.left = get_window(Window_Item_Menu).right

      # ACeEBhE쐬
      @window_item = Window_Item_Trade.new(self)

      # ACewvEBhE쐬
      item_win = get_window(Window_Item)
      x = item_win.x
      y = item_win.y + item_win.height
      w = @window_item.right - self.left
      h = Markup_New_Line.line_height * 3 + 32
      @window_help = Window_Markup_Text.new(x,y,w,h)
      @window_help.back_opacity = item_win.back_opacity
      @window_help.visible = true
      refresh_help

      # qEBhEɒǉ
      add_child @window_item
      add_child @window_help
    end

    #--------------------------------------------------------------------------
    # XV
    #--------------------------------------------------------------------------
    def update
      if @message_end
        get_window(Window_Item_Menu).dispose
        get_window(Window_Item).refresh
        return
      end
      super
    end

    def select_party_backpack
      from_actor = get_window(Window_Actor_Menu_Item).actor
      from_actor = get_window(Window_Actor_Menu_Item).backpack if from_actor.nil?
      from_item  = get_window(Window_Item).item
      to_actor = $game_party
      Item_Facade.trade_item(from_actor,from_item,to_actor)
      case from_actor
      when Game_Actor
        menu_log_hand_item_backpack(from_actor,from_item)
        @message_end = true
      when Game_Party
        menu_log_trade_item_backpack(from_item)
        @message_end = true
      end
    end

    def select_actor
      item = get_window(Window_Item).item
      if self.actor.backpack.addit? item
        # ǉłꍇ͋󔒗ɃJ[\킹
        @window_item.index = self.actor.backpack.item_count
      else
        # ǉłȂꍇ͑i̎̃ACe
        @window_item.index = Item_Facade.equip_items(self.actor).size
      end
      set_active_window(Window_Item_Trade)
    end

    def change_actor
      @window_item.refresh
      refresh_help
    end

    def refresh_help
      if (not @window_help.nil?) and (not @window_help.disposed?)
        item_win = get_window(Window_Item)
        item = item_win.item
        if actor.nil?
          refresh_help_backpack(item)
        else
          case item
          when Game_Item
            refresh_help_item(item)
          when Game_Weapon
            refresh_help_weapon(item)
          when Game_Armor
            refresh_help_armor(item)
          else
            @window_help.set_text ""
          end
        end
      end
    end

    def refresh_help_item(item)
      @window_help.set_text item.description
    end

    def refresh_help_weapon(weapon)
      text = weapon.description.dup
      text.gsub!(/\n/," ")
      text += '\bottom'
      if Item_Facade.equippable?(weapon,actor)
        (equip_prev,equip_next) = Item_Facade.equip_ability_calc(weapon,actor)
        equip_text = "#{equip_prev}  #{equip_next}"
        text += "\\right[#{equip_text}]."
      else
        text += "\\right[тłȂ]."
      end
      @window_help.set_text text
    end

    def refresh_help_armor(armor)
      text = armor.description.dup + '\bottom'
      if Item_Facade.equippable?(armor,actor)
        (equip_prev,equip_next) = Item_Facade.equip_ability_calc(armor,actor)
        equip_text = "#{equip_prev}  #{equip_next}"
        text += "\\right[#{equip_text}]."
      else
        text += "\\right[тłȂ]."
      end
      @window_help.set_text text
    end

    def refresh_help_backpack(item)
      text = 'ӂ̂Ȃ\n'
      count = $game_party.backpack.item_count_id(item.id,item.type)
      if 0 < count
        text += '͂Ă'
      else
        text += '͂ĂȂ'
      end
      @window_help.set_text text
    end
  end

end
